--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Mahajanga
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "ma_marketkeep" }
DefineCharacter { name = "ma_farmkeep" }
DefineCharacter { name = "ma_factorykeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "mahajanga",
	available = false,
	ambient = "sfx/village_loop.ogg",

	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_02", time=150000, loop=true, htile=true, path={{800,20},{700,20},{100,20},{0,20}}, },
	
		Factory { name="ma_factory", character="ma_factorykeep", price = 1865000, x=519+106/2,y=17+113/2 },
		PlayerLogo { name="logo", x=526+92/2,y=27+52/2, scale=0.25, target="ma_factory" },
		SpriteLayer { image="ma_factorymask", x=474+194/2,y=63+106/2 },
		SpriteLayer { image="ma_cloudmask", x=500,y=77 },

		-- Train
		SpriteLayer { image="train_02", scale=.5, time=20000,hold=15000,bounce=true,
			path={{863,192},{499,193},{86,193},{-84,190},},},

		EmptyBuilding { name="ma_station", ambient="sfx/other_loop.ogg", x=493+192/2,y=104+108/2 },
	
		Market { name="ma_market", character="ma_marketkeep", x=237+232/2,y=138+104/2,
			inventory = { cacao=true, sugar=true, vanilla = true, coffee=true, mint = true} },
		SpriteLayer { image="ma_midtree", x=389+124/2,y=138+100/2 },
		
		-- Vehicles (Carts/Cars)
		SpriteLayer { imagelist=portCars, scale=.5, time=20000,hold=4000,bounce=true,
			path={{-80,240},{100,240},{750,220},{880,220}} },

		SpriteLayer { image="ma_rtree", x=689+99/2,y=165+79/2 },
		SpriteLayer { image="ma_ltree", x=100+188/2,y=140+147/2 },
		
		-- Boats/Canoes
		SpriteLayer { image="boat_06", scale=.6, time=30000,hold=5000,bounce=true,
			path={{-94,340},{102,294},{750,280},{881,273},},
		},
		
		Market { name="ma_farm", character="ma_farmkeep", x=0+225/2,y=177+177/2,
			ambient = "sfx/farm_loop.ogg",
			inventory = { ma_cacao=true}, dialog="farm_mahajanga" },
		SpriteLayer { image="ma_farmmask", x=0+247/2,y=320+73/2 },
	},
}
